#include <iostream>
#include <CPPToPigpio.h>

#define I2C_SDA p2
#define I2C_SCL p3

using namespace std;

int main() {
    
    CPPToPigpio::I2C acc(I2C_SDA, I2C_SCL);
    
    CPPToPigpio::BusOut LEDs(p21, p20, p16, p12);
    
    char initWrite[] = {0x20, char(0xC0)};
    char dataGet[] = {0x28};
    char dataFromStuff[2];
    
    acc.write(0x35 << (1), initWrite, 2, false);
    
    time_sleep(1);
    
    while(1) {
        acc.write(0x35 << (1), dataGet, 1, false);
        acc.read(0x35 << (1) | 1, dataFromStuff, 2, false);
        
        int superAcc = dataFromStuff[0] + (dataFromStuff[1] <<(8));
        
        cout << "acc gotten is " << superAcc << endl;
        
        int writeEm = superAcc >>(12);
        
        LEDs = writeEm;
        time_sleep(1);
    }
}
